module net.BurtonRadons.dig.common.radioGroup;

/** This provides a tool for organising sets of RadioButton.
  * Although you can make radio sets without the help of this
  * class, this can greatly reduce the amount of code needed.
  */

class RadioGroup
{
    import net.BurtonRadons.dig.platform.radioButton;
    
/+
#ifdef DOXYGEN_NEEDNT_SEE_THIS
+/

    class Value
    {
        RadioGroup group;
        RadioButton radio;
        int value;
        void delegate () call;
        bit hasCall;

        this (RadioGroup group, RadioButton radio, int value)
        {
            this.group = group;
            this.radio = radio;
            this.value = value;
            radio.onClick.add (&checked);
            radio.checked (value == group.value ());
        }

        void checked ()
        {
            group.value (value);
        }
    }

/+
#endif
+/

    Value [] radios; /**< The list of radios in the set. */

    void delegate (int value) set;
    /**< This delegate, if not null, is sent when one of the radio buttons
       * has been clicked on and it is not already enabled.
       */

    /** Clear values. */
    this ()
    {
        set = &digPlatformSetEmpty;
    }

    /** Add a radio button to the group. */
    void add (RadioButton radio, int value)
    {
        radios ~= new Value (this, radio, value);
    }

    /** Add a radio button to the group with a delegate that will be called when that radio is selected. */
    void add (RadioButton radio, int value, void delegate () call)
    {
        radios ~= new Value (this, radio, value);
        radios [radios.length - 1].call = call;
        radios [radios.length - 1].hasCall = true;
    }

    /** Add a radio button to the group with a delegate that will be called when that radio is selected. */
    void add (RadioButton radio, void delegate () call)
    {
        add (radio, radios.length, call);
    }

    /** Read the current value. */
    int value ()
    {
        return digPlatformValue;
    }

    /** Assign the current value, posting messages and changing enable states. */
    void value (int v)
    {
        if (v == digPlatformValue)
            return;
        digPlatformValue = v;
        for (int c; c < radios.length; c ++)
        {
            if (radios [c].value == v)
            {
                if (radios [c].hasCall)
                    radios [c].call ();
                radios [c].radio.checked (true);
            }
            else
                radios [c].radio.checked (false);
        }

        set (v);
    }
    
/+
#ifdef DoxygenMustSkipThis
+/

    int digPlatformValue;

    void digPlatformSetEmpty (int value)
    {
    }
    
/+
#endif
+/
}
